<?php

/**
 * captcha antispam
 * d'après Anthony GUÉRIN et Stéphane F pour PluXml - modifié par Francis
 **/
function captcha_lang($captchalang) {
    // Appel dans le header du modèle PluXml par l'instruction PHP :   include(dirname(__FILE__) . '/captcha_lang.php');
    //
    // Utilisation dans une page statique du type 001.contact.php
    //
    // Exemple d'appel de cette fonction : $tab_captcha = captcha_lang('en');
    // Le paramètre retourné par la fonction est un tableau : il contient ici la question $tab_captcha['q'] et la réponse $tab_captcha['r']
    //
    // Dans le formulaire, inscrire la question en clair, une zone de saisie (name="rep" par exemple) et la réponse dans un champ texte masqué (name="rep2" par exemple)
    // => il suffira de comparer la réponse attendue 'rep2' (déjà codée par la fonction sha1) avec le même codage de la saisie 'rep' : 
    //    if(sha1($_POST['rep']) == $_POST['rep2']) { ... } else { ... }
     
    
    // DEBUT DU PARAMÉTRAGE
	  // -------------------------
		$min = 4; # Longueur min du mot
		$max = 6; # Longueur max du mot

	  $word = false; # Mot du captcha
	  $num = false; # Numero de la lettre selectionne
	  $numletter = false; # Numéro de la lettre sélectionnée, exprimée sous forme de mots dans la langue choisie
    
    
    switch ($captchalang) {
    
      case 'en':  // anglais
          $type_captchaquestion = 'What is the <span class="captcha-letter">%1$s</span> letter of the word <span class="captcha-word">%2$s</span> ?';
          $last = 'last';
      		$array = array(
                 '1' => 'first',
            		 '2' => 'second',
            	   '3' => 'third',
            		 '4' => 'fourth',
            		 '5' => 'fifth',
            		 '6' => 'sixth',
            		 '7' => 'seventh',
            		 '8' => 'eighth',
            		 '9' => 'ninth',
            		 '10' => 'tenth');
          $th = 'th'; // "ème" comme dans 12ème
          break;
      
      case 'zh':  // chinois
          // numérotation inverse des arguments dans la structure de la question, car le mot doit s'afficher avant la position de la lettre à donner
          $type_captchaquestion = '<span class="captcha-word">%2$s</span> 的第 <span class="captcha-letter">%1$s</span> 字母是什么 ?';
          $last = '最后';
      		$array = array(
                 '1' => '一个',
            		 '2' => '二个',
            	   '3' => '三个',
            		 '4' => '四个',
            		 '5' => '五个',
            		 '6' => '六个',
            		 '7' => '七个',
            		 '8' => '八个',
            		 '9' => '九个',
            		 '10' => '十个');
          $th = '个'; // "ème" comme dans 12ème
          break;
      
      case 'fr': // français
      default:
          $type_captchaquestion = 'Quelle est la <span class="captcha-letter">%1$s</span> lettre du mot <span class="captcha-word">%2$s</span> ?';
          $last = 'derni&egrave;re';
      		$array = array(
                 '1' => 'premi&egrave;re',
            		 '2' => 'deuxi&egrave;me',
            	   '3' => 'troisi&egrave;me',
            		 '4' => 'quatri&egrave;me',
            		 '5' => 'cinqui&egrave;me',
            		 '6' => 'sixi&egrave;me',
            		 '7' => 'septi&egrave;me',
            		 '8' => 'huiti&egrave;me',
            		 '9' => 'neuvi&egrave;me',
            		 '10' => 'dixi&egrave;me');
          $th = '&egrave;me'; // "ème" comme dans 12ème
          break;
    
    } // Fin du switch($lang)
    
	  // -------------------------
    // FIN DU PARARMETRAGE
    
	  
	  // -------------------------
	  // Création du mot aléatoire
		# Taille du mot généré : aléatoire, comprise entre min et max
		$size = mt_rand($min, $max);
		# Definition des lettres utilisables de l'alphabet
		$alphabet = 'abcdefghijklmnopqrstuvwxyz';
		$size_a = strlen($alphabet);
		# Génération d'un tableau $word_tab
		for($i = 0; $i < $size; $i++)
			$word_tab[ $i ] = $alphabet[ mt_rand(0,$size_a-1) ];
		# On sérialise le tableau et on retourne la valeur
	  $word = implode('',$word_tab);
	  // -------------------------
	  
	  // -------------------------
	  // Méthode qui choisit un numéro de lettre dans le mot chois
		$num = mt_rand(1,strlen($word));
	  // -------------------------
	  
	  // -------------------------
	  // Méthode qui convertit le numéro en chaîne de caractères, dans la langue paramétrée
		# Cas où $num = dernière lettre du mot
		if($num == strlen($word))	
       { $numletter = $last; }
    else {
    		# Si la valeur existe dans le tableau
    		if(isset($array[ $num ]))
    			$numletter = $array[ $num ];
    		else # Sinon on retourne une valeur generique
    			$numletter = $num . $th;
    }
	  // -------------------------
    
    $tab_captcha['q'] = sprintf($type_captchaquestion, $numletter, $word);;
    $tab_captcha['r'] = sha1($word_tab[$num-1]);
    return $tab_captcha;
  
  }
   

?>
