<?php
class artPS extends plxPlugin {

		public function __construct($default_lang) {
			parent::__construct($default_lang);
			
			$this->setConfigProfil(PROFIL_ADMIN);
			$this->addHook('artPS', 'artPS'); // cration du hook
			$this->addHook('AdminTopEndHead', 'AdminTopEndHead'); // insre la feuille de style du backoffice
		}


		public function AdminTopEndHead() { // insre la feuille de style du backoffice
			echo "\t".'<link rel="stylesheet" type="text/css" href="'.PLX_PLUGINS.'artPS/style_artPS.css" media="screen" />'."\n";
		}

		public function artPS($mode) {
		$plxShow = plxShow::getInstance();
		$plxMotor = plxMotor::getInstance();

			$ordre = preg_match('/asc/',$plxShow->plxMotor->tri)?'sort':'rsort';
			
			if($mode AND $plxShow->catId()!= "home") { // parmis tous les articles de sa catgorie
			$ID_CAT = str_pad ($plxShow->catId(), 3, '0', STR_PAD_LEFT);
			$aFiles = $plxShow->plxMotor->plxGlob_arts->query('/[0-9]{4}.['.$ID_CAT.']*.[0-9]{3}.[0-9]{12}.[a-z0-9-]+.xml$/','art',$ordre,0,false,'before');
			} else { // parmis tous les articles
				$aFiles = $plxShow->plxMotor->plxGlob_arts->query('/[0-9]{4}.[home|0-9,]*.[0-9]{3}.[0-9]{12}.[a-z0-9-]+.xml$/','art',$ordre,0,false,'before');
			}


			$key = array_search(basename($plxShow->plxMotor->plxRecord_arts->f('filename')), $aFiles);
			$prevUrl = $prev = isset($aFiles[$key-1])? $aFiles[$key-1] : false;
			$nextUrl = $next = isset($aFiles[$key+1])? $aFiles[$key+1] : false;

			$plxGlob_arts = clone $plxShow->plxMotor->plxGlob_arts;

				if($prev AND preg_match('/([0-9]{4}).[home|0-9,]*.[0-9]{3}.[0-9]{12}.([a-z0-9-]+).xml$/',$prev,$capture))
					$prevUrl=$plxShow->plxMotor->urlRewrite('?article'.intval($capture[1]).'/'.$capture[2]);
					if ($prev){
						$art = $plxShow->plxMotor->parseArticle(PLX_ROOT.$plxShow->plxMotor->aConf['racine_articles'].$prev);
						$nextTitle = STRIP_TAGS($art['title']);
					}
				if($next AND preg_match('/([0-9]{4}).[home|0-9,]*.[0-9]{3}.[0-9]{12}.([a-z0-9-]+).xml$/',$next,$capture))
					$nextUrl=$plxShow->plxMotor->urlRewrite('?article'.intval($capture[1]).'/'.$capture[2]);
					if ($next) {
						$art = $plxShow->plxMotor->parseArticle(PLX_ROOT.$plxShow->plxMotor->aConf['racine_articles'].$next);
						$prevTitle = STRIP_TAGS($art['title']);
					}
				if($ordre=='rsort') { $dummy=$prevUrl; $prevUrl=$nextUrl; $nextUrl=$dummy; }
			if($prevUrl) echo '<p class="pre"><a href="'.$prevUrl.'" title="'.$prevTitle.'"><span>'.$this->getlang("nextLib").'</span> '.$prevTitle.'</a></p>';
			if($nextUrl) echo '<p class="next"><a href="'.$nextUrl.'" title="'.$nextTitle.'"><span>'.$this->getlang("prevLib").'</span> '.$nextTitle.'</a></p>';
		}

	}

?>