<?php if(!defined('PLX_ROOT')) exit; ?>
<h2>Aide</h2>
<p>Ce plugin crée automatiquement un menu, à partir de la liste des articles d'une catégorie.</p>
<p>Pour afficher un sous-menu sous un article, il suffit d'associer le numéro de cet article avec le numéro de la catégorie des articles constituant le sous-menu (par ex. artcat="art16-cat7").</p>

<br />
<h3>--- Exemple d'utilisation ---</h3>
<br />
<p>
Dans cet exemple, les catégories sont :<br /><br>
1 : Menu principal (articles Accueil, Fruits, Légumes, Contact)<br />
2 : Pied de page (articles Mentions légales, Plan du site)<br />
3 : Fruits (articles Pommes, Poires, Oranges)<br />
4 : Légumes (articles Carottes, Salades, Haricots verts)<br />
5 : Types de poires (articles Poires William, Poires Abbate, Poires Rocha)<br />
</p>

<br />
<p>L'objectif est d'obtenir le menu suivant (ici à trois niveaux) :</p>

<br />
<ul>
  <li>• Accueil (article 1)<br /><br /></li>
  <li>• Fruits (article 2, associé à la catégorie 3)<br />
      <ul>
          <li>&nbsp;&nbsp;&nbsp;- Pommes (article 3)<br /></li>
          <li>&nbsp;&nbsp;&nbsp;- Poires (article 4, associé à la catégorie 5)
              <ul>
                  <li>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;. Poires William (article 11)</li>
                  <li>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;. Poires Abbate (article 12)</li>
                  <li>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;. Poires Rocha (article 13)</li>
              </ul>
          </li>
          <li>&nbsp;&nbsp;&nbsp;- Oranges (article 5)<br /><br /></li>
      </ul>
  </li>
  <li>• Légumes (article 6, associé à la catégorie 4)<br />
      <ul>
          <li>&nbsp;&nbsp;&nbsp;- Carottes (article 7)</li>
          <li>&nbsp;&nbsp;&nbsp;- Salades (article 8)</li>
          <li>&nbsp;&nbsp;&nbsp;- Haricots verts (article 9)</li>
      </ul>
  <br /></li>
  <li>• Contact (article 10)</li>
</ul>

<br />
<p>Il faut donc écrire le code suivant :<br /><br />
    <strong>[plxmenu numcat="1" artcat="art2-cat3, art6-cat4, art4-cat5"]</strong></p>

<br /><br />
<p>
  Pour un menu sans sous-menu, il suffit de ne pas mentionner le paramètre artcat (ou de lui attribuer une chaîne vide).<br /><br />
  
  Début de chaque liste (par défaut, c'est le début de balise ul) : menudebut="..." pour le menu de niveau 1, sousmenudebut="..." pour tous les sous-menus<br />  
  Fin de chaque liste (par défaut, c'est la fin de balise ul) : menufin="..." pour la liste principale, sousmenufin="..." pour tous les sous-menus<br />
  => ceci permet de fournir une balise ul avec une classe, ou bien de ne pas mettre de balise ul pour les sous-menus (dans ce cas, fin de balise li pour l'article AVANT le sous-menu associé)<br /><br />
  
  Classe attribuée à chaque ligne de la liste (par défaut : pas de classe) :
  <br />classli="..." pour les lignes du menu de niveau 1, sousmenuclassli="..." pour les lignes de tous les sous-menus<br /><br />
  
  Tri des articles dans le menu de niveau 1 : tri="date" (valeur par défaut) pour un affichage par ordre de dates croissantes, tri="dateinv" pour un ordre de dates décroissantes<br />   
  Tri des articles dans tous les sous-menus : sousmenutri="date" (valeur par défaut) pour un affichage par ordre de dates croissantes, sousmenutri="dateinv" pour un ordre de dates décroissantes<br /><br />
  
  En mode "home" (page d'accueil), pour attribuer la classe "active" à un article qui est utilisé comme page d'accueil : homeart='1' par exemple, si c'est l'article 1 (id de l'article).<br />
</p>
 

