<?php
// Plugin PluXml plxmenu version 1.3

    class plxmenu extends plxPlugin {

        public function __construct($default_lang) {

            # appel du constructeur de la classe plxPlugin (obligatoire)
            parent::__construct($default_lang);

            # limite l'accès a l'écran d'administration du plugin
            $this->setConfigProfil(PROFIL_ADMIN);

        		# Ajouts des hooks
        		$this->addHook('plxmenu', 'plxmenu');

            # Pour utiliser le shortcode défini dans le plugin
            $this->setParam('spxshortcodes_shortcode', '1', 'string');
        }

        
        
      /* ---------------------------- FONCTION menucategorie ---------------------------------*/
    	/**
    	 * Méthode menucategorie qui fournit la liste des articles d'une catégorie
       * $numcat = n° de la catégorie d'articles à lister
       * $classli = classe éventuelle à ajouter aux lignes li, en plus de "active"/"noactive"
       *
       * $uldebut = balise de début comme "<ul>" ou "<ul class='menuprincipal'>" par exemple ; si balise_ul="", les lignes li ne sont pas entourées par la balise ul
       * $ulfin = balise ul de fin comme "</ul>" (si $uldebut contient la chaîne "<ul" et que $ulfin est vide, $ulfin="</ul>)
       * 
       * - En mode "home", s'il faut donner la classe "active" au lieu de "noactive" à la ligne (balise li) associée à un article qui sert de page d'accueil,                  
       *   fournir l'id de cet article : par exemple,  homeart = 1 si c'est l'article 1
       *   => son url est également remplacée par celle du fichier index.php ; pour éviter ce remplacement d'url, écrire :   'homeart'=>'art-1'   au lieu de 'homeart'=>'1'                  
	     *    
    	 * @return	stdio
    	 * @author	Francis D.
    	 **/
      public static function menucategorie($tab) {
        // Intitialisations
        extract($tab, EXTR_OVERWRITE);
        $plxShow = plxShow::getInstance();
        
        // Pour le remplacement en mode "home", dans la ligne associée à la page d'accueil, de "noactive" par "active"  et de l'url de l'article par celle du fichier index.php 
        $conserver_urlart = ( substr($homeart, 0, 4)=="art-" || $homeart=='' || $homeart==0 ); // vrai si l'url de l'article ne doit pas être remplacée par celle du fichier index.php
        $homeart = str_replace("art-", "", $homeart); // n° article sans le préfixe éventuel "art-" (signifiant qu'il ne faut pas remplacer son url - seulement la classe "active" en mode "home")
        
        if ($classli!="" && substr($classli, 0, 1)!=" ") $classli = " " . $classli;
        $ordretri = ($tri=="dateinv")?   'rsort'   :   'sort'; // tri par défaut 'sort' (dates croissantes de création des articles); si $tri="dateinv", tri 'rsort' (dates décroissantes)
        
        // Si $mode_homeartactive=="home" avec paramètre $homeart défini, alors ajout de l'id de l'article + de caractères spécifiques pour la fonction explode
        if ( $homeart=='' || $homeart==0 ) { $modele = '<li class="#art_status' . $classli . '"><a href="#art_url" title="#art_title">#art_title</a></li>'; }
                        else { $modele = '#art_id*@@@*<li class="#art_status' . $classli . '"><a href="#art_url" title="#art_title">#art_title</a></li>*@@@*'; } // "*@@@*" pour explode ensuite
        ob_start();
          $plxShow->lastArtList($modele, '1000', $numcat, '', 'sort'); //liste les articles de la catégorie
        $txt = ob_get_clean();
        
                
        if ( $homeart!='' && $homeart!=0 ) {
            $tabtxt = explode("*@@@*", $txt);
            $nouvtxt = "";
           for ($j=0; $j<count($tabtxt)-1; $j++) {
              	$txtligne = $tabtxt[$j+1];
                // en mode "home" et pour l'article associé à la page d'accueil : pour cette ligne, classe "active" au lieu de "noactive" 
                if ($plxShow->mode()=='home' && $tabtxt[$j]==$homeart) { $txtligne = str_replace("noactive", "active", $txtligne); }
                // remplacement &ventuel de l'url de l'article par celle du fichier index.php (si l'id d'article associé à la pg d'accueil n'est pas précédé par "art-")
                if (! $conserver_urlart && $tabtxt[$j]==$homeart) { 
                    ob_start();     $plxShow->racine();     $url_racine = ob_get_clean(); // url de la page d'accueil index.php
                    $txtligne = preg_replace( '/(href=".*")/',  'href="'.$url_racine.'"',  $txtligne );
                }
                $nouvtxt .= $txtligne;
                $j++;
            }
            $txt = $nouvtxt;
        } // fin if ( $homeart!='' && $homeart!=0 ) - un article est associé à la page d'accueil
        
        
        // Balise <ul>...</ul> uniquement si demandée, suivant les arguments menudebut et menufin
        $txt = str_replace("<ul>", $menudebut, $txt); 
        $txt = str_replace("</ul>", $menufin, $txt);    
        return $txt;
      }
      /* -------------------------------------------------------------------------------------*/
        
      /* -------------------------------------------------------------------------------------*/
        
      /* Attribue les valeurs par défauts aux paramètres non fournis dans le tableau, conserve ceux qui ont été transmis
       * (d'après la fonction shortcode_atts du plugin spxshortcodes de JE Evrard)
    	 * @return	stdio
    	 * @author	Francis D.
    	 **/
      public function default_atts($tab_defaultparams, $atts) { 
      	$atts = (array)$atts; // transformation de l'argument $atts en tableau, au cas où ce serait une valeur simple
      	$tab_out = array();
      	foreach($tab_defaultparams as $name => $default) {
      		if ( array_key_exists($name, $atts) )		$tab_out[$name] = $atts[$name];
      		                                 else   $tab_out[$name] = $default;
      	}
      	return $tab_out;
      }
      /* -------------------------------------------------------------------------------------*/

        




       /* ---------------------------- FONCTION plxmenu - ATTENTION : utilisation des fonctions menucategorie et default_atts ci-dessus ---------------------------------*/
        
       /* Renvoie la liste des liens associés à une catégorie, avec pour certains articles un sous-menu (liste des articles de la catégorie associée)
        * Le nombre des niveaux de sous-menus est illimité (voir exemple d'utilisation sous le code de la fonction)
        * - Utilisation de la fonction menucategorie_func (liste des articles d'une catégorie donnée)
        *
        * - Association d'une catégorie à chaque article concerné => avec l'attribut artcat="art8-cat3, art10-cat4, art16-cat-7" par exemple
        *   (si artcat est vide, pas de sous-menu ; l'ordre des paires article-catégorie n'a pas d'importance)
        * - Classe attribuée à chaque ligne du menu principal : classli (vide par défaut)
        * - Classe attribuée à chaque ligne du sous-menu : sousmenuclassli (vide par défaut)
        * - Articles listés par date croissante (tri="date" sousmenutri="date" - valeurs par défaut) ou  par date décroissante (tri="dateinv" sousmenutri="dateinv" pour le menu et les sous-menus)
        * 
        * - En mode "home", s'il faut donner la classe "active" au lieu de "noactive" à la ligne (balise li) associée à un article qui sert de page d'accueil,                  
        *   fournir l'id de cet article : par exemple,  homeart = 1 si c'est l'article 1
        *   => son url est également remplacée par celle du fichier index.php, sauf si au lieu de 'homeart'=>'1' on écrit 'homeart'=>'art-1'                  
        *
        * Dans l'appel de la fonction, ne pas renseigner le paramètre "recursive", utilisé en interne pour tester la récursivité (pour RAZ variables statiques tout à la fin)

    	  * @return	stdio
    	  * @author	Francis D.
    	  **/
        public function plxmenu($tabparams) {

          // -----------------------
          // Paramètres et variables
          // -----------------------
          $default_numcat = $this->getParam('defaultnumcat');
          if ($default_numcat=="" || $default_numcat==0) $default_numcat = 1; // Catégorie par défaut : celle indiquée dans la configuration du plugin, sinon 1
            
          // Dans le tableau de paramètres $tabparams, remplacement de "&lt;" et "&gt;" par "<" et ">" (parties de balises HTML qui sont transformées par l'éditeur Wysiwyg)
          $tabparams = str_replace(array('&lt;', '&gt;'), array('<', '>'), $tabparams);  
          
          
          // Par défaut, menufin="", mais si menudebut contient la chaîne "<ul", menufin vaut automatiquement "</ul>" ; idem pour sousmenufin
          extract(plxmenu::default_atts(array("numcat"=>$numcat, "artcat"=>'', "homeart"=>'', "recursive"=>false,
                                     "classli"=>'', "menudebut"=>"<ul>", "menufin"=>"", "tri"=>"date",
                                     "sousmenuclassli"=>"", "sousmenudebut"=>"<ul>", "sousmenufin"=>"", "sousmenutri"=>"date"), $tabparams), EXTR_OVERWRITE);
        
          $plxShow = plxShow::getInstance();
          $plxMotor = plxMotor::getInstance();
          
          // Variables utilisées uniquement s'il y a récursivité => variables STATIQUES qui ne seront pas rénitialisées par cette récursivité (RAZ à la fin de l'appel initial)
          static $listecatsvues = "";
          static $listearts_stopsousmenu = "";
          // -----------------------
          
          // Traitement et ajustement des paramètres fournis
          if ($numcat=="" || $numcat==0) $numcat = $default_numcat;
          if ($classli!="" && substr($classli, 0, 1)!=" ") $classli = " " . $classli;
          if (strstr($menudebut, "<ul") && $menufin=="")  $menufin = "</ul>";
          if (strstr($sousmenudebut, "<ul") && $sousmenufin=="")  $sousmenufin = "</ul>";
          // Si catégorie déjà traitée, arrêt de la fonction, sinon ajout de la catégorie courante à la liste des catégories déjà traitées
          $tab_listecatsvues = explode("-", $listecatsvues);
          if (in_array($numcat, $tab_listecatsvues)) { 
                      if(! $recursive) { $listecatsvues = ""; $listearts_stopsousmenu = ""; }
                      return "";
              }
              else { $listecatsvues = ($listecatsvues=="")?   $numcat   :   $listecatsvues."-".$numcat; }
          
        
          // Récupération de la liste artcat => tableaux des numéros d'articles $tab_numart, des catégories $tab_numcat et des url $tab_arturl
          $tab_paires_artcat = explode(",", $artcat); // récupération des paires commme "art16-cat7" dans un tableau

          for ($i=0; $i<count($tab_paires_artcat); $i++) {
              $tab = explode("-", ltrim(rtrim($tab_paires_artcat[$i])));
              $tab_numart[$i] = str_replace("art", "", $tab[0]); // n° seul de l'article, sans "art" avant
              $tab_numcat[$i] = str_replace("cat", "", $tab[1]); // n° seul de la catégorie, sans "cat" avant
              $tab_stopsousmenu[$i] = false; // sera mis à 1 dès que l'article sera utilisé pour un sous-menu
              
              // Récupération dans un tableau $tab_arturl de l'URL réécrite de l'article, pour test ultérieur : présence ou non de l'article dans chaque ligne du menu généré => sous-menu ou non
              ob_start();
                $plxShow->urlRewrite("article" . $tab_numart[$i]);
              $txturl = ob_get_clean();
              $tab_arturl[$i] = $txturl; // récupération de l'URL réécrite de l'article, pour recherche ensuite dans la liste générée
          }
        
          // Création des lignes de menu
          $txt = '';
          $lignes = plxmenu::menucategorie(array("numcat"=>$numcat, "classli"=>$classli, "menudebut"=>"", "tri"=>$tri, "homeart"=>$homeart));
          $sp = "||µ||"; // séparateur pour distribuer les lignes dans un tableau, avec la fonction explode
          $lignes = str_replace("</li>", "</li>".$sp, $lignes); // pour séparer les lignes avec la fonction explode qui suit
          if (substr($lignes,-strlen($sp))==$sp) { $lignes = substr($lignes, 0, -strlen($sp)); } // suppression du dernier séparateur, pour éviter un élément en trop (chaîne vide) dans le tableau
          $tab_lignes = explode($sp, $lignes);
          
          // Recherche et insertion de sous-menu éventuel, pour chacune des lignes  
          $ligne = "";
          foreach ($tab_lignes as $ligne) {
              // Dans chaque ligne, recherche de la présence d'un des articles associé à un sous-menu (parcours des articles fournis par $artcat2 = $artcat moins les articles déjà traités)
              for ($i=0; $i<count($tab_arturl); $i++) {
                    
                    // Si sous-menu possible ($tab_stopsousmenu[$i]==false) et URL de l'article détectée dans la ligne, 
                    // et à condition que la nouvelle catégorie ne soit pas celle courante, ni 0 ni une chaîne vide,
                    // ajout du sous-menu juste après la ligne de cet article, par appel récursif de la fonction
                    if (!$tab_stopsousmenu[$i] && strstr($ligne, $tab_arturl[$i]) && $tab_numcat[$i]!=$numcat && $tab_numcat[$i]!=0 && $tab_numcat[$i]!="") 
                    {
                        $tab_stopsousmenu[$i] = true; // protection des rebouclages infinis : plus d'autre sous-menu possible pour cet article, même si on le retrouve dans une autre catégorie
                        $sousmenu = plxmenu::plxmenu(array("numcat"=>$tab_numcat[$i], "artcat"=>$artcat, "recursive"=>true,
                                                  "classli"=>$sousmenuclassli, "menudebut"=>$sousmenudebut, "menufin"=>$sousmenufin, "tri"=>$sousmenutri, 
                                                  "sousmenuclassli"=>$sousmenuclassli, "sousmenudebut"=>$sousmenudebut, "sousmenufin"=>$sousmenufin, "sousmenutri"=>$sousmenutri));
                        // Si balise ul dans le sous-menu, </li> après le sous-menu (ul imbriqué), sinon </li> avant le sous-menu (=> lignes li du sous-menu ajoutées dans la liste ul principale)
                        $apressousmenu = "";
                        if (strstr($sousmenudebut, "<ul"))
                        {
                            $ligne = substr($ligne, 0, -5); // suppression du dernier "</li>" à la fin
                            $apressousmenu = "</li>"; // ajout de "</li>" après le "</ul>" du sous-menu
                        }              
                        $ligne = $ligne . "\n" . $sousmenu . "\n" . $apressousmenu;
                    } // Fin appel sous-menu lorsqu'une occurence est trouvée (= lorsqu'un article associé à un sous-menu a été trouvé dans la ligne courante de menu)
              } // Fin boucle for (recherche de chacune des url concernées)
          
          $txt = $txt . $ligne . "\n";
          } // Fin du bouclage sur chaque ligne du menu principal
          
        
          $txt = $menudebut . $txt . $menufin;
          
          if(! $recursive) { $listecatsvues = ""; $listearts_stopsousmenu = ""; }
          return $txt;
        }

/* ------------------------------------------------------------------------------------------------------------------------------------------------*/


/*
Exemple d'utilisation
---------------------

Dans cet exemple, les catégories sont :
1 : Menu principal (articles Accueil, Fruits, Légumes, Contact)
2 : Pied de page (articles Mentions légales, Plan du site)
3 : Fruits (articles Pommes, Poires, Oranges)
4 : Légumes (articles Carottes, Salades, Haricots verts)
5 : Types de poires (articles Poires William, Poires Abbate, Poires Rocha)

L'objectif est d'obtenir le menu suivant (ici à trois niveaux) :

- Accueil (article 1)
- Fruits (article 2, associé à la catégorie 3)
    - Pommes (article 3)
    - Poires (article 4, associé à la catégorie 5)
        - Poires William (article 11)
        - Poires Abbate (article 12)
        - Poires Rocha (article 13)
    - Oranges (article 5)
- Légumes (article 6, associé à la catégorie 4)
    - Carottes (article 7)
    - Salades (article 8)
    - Haricots verts (article 9)
- Contact (article 10)

=> il faut donc écrire en PHP :
  $menu =  eval($plxShow->callHook('plxmenu', array('numcat'=>'1', 'artcat'=>'art2-cat3, art6-cat4, art4-cat5')));
  echo $menu;

  ou pour l'affichage dans une page, le shortcode suivant (plugins spxshortcode et shortcode_p activés) :
    [-p-plxplugin plugin="val-plxmenu" numcat="1" artcat="art2-cat3, art6-cat4, art4-cat5"] 
*/




    }

?>
