<?php

class test extends plxPlugin {

	/**
	 * Constructeur de la classe test
	 *
	 * @param	default_lang	langue par défaut utilisée par PluXml
	 * @return	null
	 * @author	Francis
	 **/
  public function __construct($default_lang) {

      # appel du constructeur de la classe plxPlugin (obligatoire)
      parent::__construct($default_lang);

  		# droits pour accéder à la page config.php du plugin
  		$this->setConfigProfil(PROFIL_ADMIN);
		  
  		# Ajouts des hooks
  		$this->addHook('test', 'test');

      # Pour utiliser le shortcode défini dans le plugin
      $this->setParam('spxshortcodes_shortcode', '1', 'string');
  }

	/**
	 * Méthode qui initialise le fichier de paramètres à l'activation du plugin
	 * => son écriture est facultative, s'il n'y a pas de valeur initiale à indiquer
	 * 
	 * A noter : Si le plugin est activé puis désactivé, le fichier xml existe déjà à la réactivation du plugin
	 *           => pas de réinitialisation des paramètres à la réactivation      
	 *    
	 * @return	stdio
	 * @author	Francis
	 **/
	public function onActivate() {
  		if(!is_file($this->plug['parameters.xml'])) {
      			$this->setParam('param_a', 'valeur A initiale', 'string');
      			$this->setParam('param_b', 'valeur B initiale', 'string');
      			$this->saveParams();
  		}
	}

	
  
	/**
	* Contenu affiché par la fonction test : texte fixe (avec nom du plugin) et valeurs de quatre paramètres
	* (paramètres 1 et 2 fournis en argument, paramètres A et B définis dans la configuration du plugin)
	*
  * Pour appeler ce plugin :
  *                     $texte = eval($plxShow->callHook('test', array('param1'=>'valeur1', 'param2'=>'valeur2')));
  *                     echo $texte;
  *
  * ou affichage direct du texte, en ajoutant le paramètre 'action'=>'echo' :
  *                     eval($plxShow->callHook('test', array('action'=>'echo', 'param1'=>'valeur1', 'param2'=>'valeur2')));
  * @ return stdio
  * @author Francis
  **/  
  public function test($tabparams) {
    extract($tabparams, EXTR_OVERWRITE);
    
		$txt = "***** Fonction test - Paramètre 1 : " . $param1 . " - Paramètre 2 : " . $param2 . 
                              " - Paramètre config A : " . $this->getParam('param_a') . " - Paramètres config B : " . $this->getParam('param_b') . " *****";
    if ($action=="echo") { echo $txt; }
                    else { return $txt; }  
	}


}

?>
